package automobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/**
 * Premier garage, affichant les véhicules qu'il contient
 * Utilise des ArrayList
 * Container de Véhicules
 * Implémente un itérateur Iterable
 * @author Adrien Poupa
 */
public class Garage1 implements Iterable<Vehicule> {

    // Pour l'instant on utilise des ArrayList
    ArrayList<Vehicule> list;

    /**
     * Constructeur par défaut de Garage1
     * Instancie l'ArrayList
     */
    public Garage1() {
        list = new ArrayList<Vehicule>();
    }

    /**
     * Ajout d'un véhicule au garage
     * Rien de particulier ici, on utilise la méthode native d'ArrayList
     * @param voiture objet Vehicule à ajouter
     */
    public void add(Vehicule voiture) {
        list.add(voiture);
    }

    /**
     * Itérateur de Garage1, contenant des Véhicules
     * Retourne une nouvelle instance de l'itérateur de garage1 prenant en paramètre l'ArrayList de voiture
     * @return objet iterator contenant les Céhicules
     */
    public Iterator<Vehicule> iterator() {
        return new IteratorGarage(list);
    }

    /**
     * Application du traitement défini par la fonction applyIt à chaque élément de TreeSet
     * @param f objet fonction à appliquer
     * Retourne la liste modifiée
     */
    public void map(Function f) {
        for(Vehicule v : list) {
            f.applyIt(v);
        }
    }

    /**
     * Permet de faire le plein de tous les véhicules en faisant une boucle for, rendue possible par l'itérateur
     * On ne fait le plein que s'il reste moins de 10L dans le réservoir
     * Implémentation mapping
     */
    public void faireLePleinAll() {
        map(new FaireLePleinAll());
    }

    /**
     * Permet de réinitialiser tous les compteurs partiels des Véhicules du garage
     * Implémentation mapping
     */
    public void resetPartielAll() {
        map(new RemiseCompteurPartiels0());
    }

    /**
     * Surcharge de toString, affiche les Véhicules contenus dans le garage
     * @return liste du type "Vehicule X : compteur = [Totalisateur = X | Partiel = X]; jauge = X"
     */
    @Override
    public String toString() {
        StringBuilder returnString = new StringBuilder();

        for(Vehicule vehicule : list) {
            returnString.append(vehicule.toString());
            returnString.append(System.getProperty("line.separator")); // Retour à la ligne
        }

        return returnString.toString();
    }

    /**
     * Tri des voitures par numéro d'immatriculation
     * J'ai laissé Immatriculion tel qu'implémenté dans la classe de tests...
     * Utilisation du sucre syntaxique
     */
    public void triNoImmatriculion() {
        Collections.sort(list, VehiculeComparator.IMMATRICULATION_ORDER);
    }

    /**
     * Tri des voitures par compteur
     * Utilisation du sucre syntaxique
     */
    public void triCompteur() {
        Collections.sort(list, VehiculeComparator.COMPTEUR_ORDER);
    }

    /**
     * Tri des voitures par jauge
     * Utilisation du sucre syntaxique
     */
    public void triJauge() {
        Collections.sort(list, VehiculeComparator.JAUGE_ORDER);
    }
}
